<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">

    <meta name="application-name" content="<?php echo e(config('app.name')); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title><?php echo e(config('app.name')); ?></title>

    <style>
        [x-cloak] {
            display: none !important;
        }
    </style>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <?php echo \Livewire\Livewire::styles(); ?>

    <?php echo \Livewire\Livewire::scripts(); ?>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</head>

<body class="antialiased">
    <header class="relative pt-6 pb-16 sm:pb-24">
        <nav class="relative flex items-center justify-between max-w-3xl px-4 mx-auto md:justify-center sm:px-6">
            <img
                class="w-auto h-10 sm:h-12"
                src="<?php echo e(Vite::asset('resources/images/lidereuropean.png')); ?>"
                alt="">

            <div class="flex items-center justify-end flex-1 space-x-10">
                
            </div>
        </nav>
    </header>

    <?php echo e($slot); ?>


    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('notifications')->html();
} elseif ($_instance->childHasBeenRendered('c6wTyzt')) {
    $componentId = $_instance->getRenderedChildComponentId('c6wTyzt');
    $componentTag = $_instance->getRenderedChildComponentTagName('c6wTyzt');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('c6wTyzt');
} else {
    $response = \Livewire\Livewire::mount('notifications');
    $html = $response->html();
    $_instance->logRenderedChild('c6wTyzt', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
</body>

</html>
<?php /**PATH /var/www/clients/client1/web26/web/lidereuropean/resources/views/layouts/app.blade.php ENDPATH**/ ?>