<?php

declare(strict_types=1);

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;

use App\Models\ContestSignup;
use App\Models\OnlineMeetingSignup;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Sequence;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        OnlineMeetingSignup::factory(1999)
            ->state(new Sequence(
                ['data' => '2022-10-06'],
                ['data' => '2022-10-07'],
            ))
            ->create();

        ContestSignup::factory(10000)
            ->create();

        User::factory(['email' => 'admin@example.com'])
            ->create();
    }
}
