<?php

declare(strict_types=1);

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class OnlineMeetingSignupFactory extends Factory
{
    public function definition()
    {
        $statut = fake()->randomElement(['profesor', 'elev']);

        return [
            'unitate' => fake()->name() . ' ' . fake()->city(),
            'statut' => $statut,
            'nume' => fake()->name(),
            'telefon' => fake()->phoneNumber(),
            'email' => fake()->unique()->safeEmail(),
            'numar_elevi' => $statut === 'profesor'
                ? fake()->randomNumber(2)
                : null,
            'clasa' => $statut === 'elev'
                ? fake()->randomElement(['IX', 'X', 'XI', 'XII'])
                : null,
            'data' => null,
        ];
    }
}
