<?php

declare(strict_types=1);

namespace App\Models;

use App\Notifications\OnlineMeetingSignupConfirmation;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Cache;

class OnlineMeetingSignup extends Model
{
    use HasFactory;
    use Notifiable;

    protected $guarded = [
        'rules', 'gdpr',
    ];

    protected $casts = [
        'numar_elevi' => 'integer',
        'data' => 'date',
    ];

    public function sendNotification()
    {
        return $this->notify(new OnlineMeetingSignupConfirmation());
    }

    public static function registrationsFullForDate(string $date): bool
    {
        if (Carbon::parse($date)->lte(today())) {
            return true;
        }

        $registrations = Cache::store('array')->rememberForever("registrations-$date", function () use ($date) {
            return self::query()
                ->whereDate('data', $date)
                ->count();
        });

        return $registrations >= 1000;
    }
}
