<?php

declare(strict_types=1);

namespace App\Exports;

use App\Models\OnlineMeetingSignup;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Database\Eloquent\Builder;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class OnlineMeetingSignupsExport implements FromQuery, ShouldAutoSize, ShouldQueue, WithHeadings, WithMapping, WithStyles
{
    use Exportable;

    public function query(): Builder
    {
        return OnlineMeetingSignup::query();
    }

    public function headings(): array
    {
        return [
            '#',
            'Dată înregistrare',

            'Denumire unitate învățământ',
            'Localitate',
            'Județ',

            'Statut',
            'Nume și prenume',
            'Număr de telefon',
            'Email',

            'Număr de elevi participanți la întâlnire',
            'Clasa',
            'Dată participare la întâlnirea online',
        ];
    }

    /**
     * @param OnlineMeetingSignup $signup
     */
    public function map($signup): array
    {
        return [
            $signup->id,
            $signup->created_at,

            $signup->unitate,
            $signup->city,
            $signup->county,

            $signup->statut,
            $signup->nume,
            $signup->telefon,
            $signup->email,

            $signup->numar_elevi,
            $signup->clasa,
            $signup->data->toDateString(),
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            // Style the first row as bold text.
            1 => ['font' => ['bold' => true]],
        ];
    }
}
