<div class="relative max-w-3xl px-4 py-16 mx-auto sm:px-6 lg:px-8 lg:py-24">
    <h1 class="mb-12 space-y-2 text-3xl font-extrabold tracking-tight text-center text-gray-900 sm:text-4xl">
        <span class="block">Formular Înscriere</span>
        <span class="block">Întâlniri de Informare și Pregătire online</span>
        <span class="block">Lider European 2025</span>
    </h1>

    @if ($this->hasAlreadyRegistered())
        <div class="flex p-4 rounded-md bg-green-50">
            <svg class="w-5 h-5 text-green-400 shrink-0" viewBox="0 0 20 20"
                fill="currentColor" aria-hidden="true">
                <path fill-rule="evenodd"
                    d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.857-9.809a.75.75 0 00-1.214-.882l-3.483 4.79-1.88-1.88a.75.75 0 10-1.06 1.061l2.5 2.5a.75.75 0 001.137-.089l4-5.5z"
                    clip-rule="evenodd" />
            </svg>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-green-800">
                    V-ați înscris la întâlnirea online din data de {{ $this->registeredDate() }}.
                </h3>

                <div class="mt-2 text-sm text-green-700">
                    Verificați adresa de e-mail pentru confirmare și link-ul de participare la întâlnire!
                </div>
            </div>
        </div>
    @endif

    @if ($this->isFormOpen())
        @if (!$this->hasAlreadyRegistered())
            <x-check-info class="mb-8" />

            <form wire:submit.prevent="submit">
                {{ $this->form }}

                <button type="submit"
                    class="inline-flex items-center justify-center w-full px-6 py-3 mt-6 text-base font-medium text-white bg-blue-600 border border-transparent rounded-md shadow-sm hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                    Trimite
                </button>
            </form>

            <div class="mt-12 prose-sm prose max-w-none prose-blue">
                <p>
                    Pentru Regulament, Acord GDPR, Calendar, Înscrierea proiectelor în concurs, Informații si Materiale
                    de pregǎtire pentru concursul Lider European, organizat de Reprezentanța Comisiei Europene în
                    România în parteneriat cu Ministerul Educației, accesați:
                    <a
                        href="https://romania.representation.ec.europa.eu/lider-european_ro"
                        target="_blank"
                        class="hover:underline"
                        rel="noopener">
                        https://romania.representation.ec.europa.eu/lider-european_ro
                    </a>
                </p>
            </div>
        @endif
    @else
        <div class="mx-auto mt-6 prose prose-lg text-gray-600 prose-blue">
            <p>
                Bună ziua!
            </p>

            <p>
                Vă mulțumim pentru interesul acordat concursului național Lider European, ediția 2025!
            </p>

            @if ($this->start_date->isFuture())
                <p>
                    Perioada dedicată înscrierii la întâlnirile online de informare și pregătire începe pe
                    <span
                        class="font-semibold whitespace-nowrap">{{ $this->start_date->isoFormat('DD MMMM Y') }}</span>.
                </p>

                <div class="pointer-events-none select-none">
                    <script src="https://cdn.logwork.com/widget/countdown.js"></script>
                    <a href="https://logwork.com/countdown-timer" class="countdown-timer"
                        data-style="columns"
                        data-timezone="Europe/Bucharest" data-language="ro" data-date="2025-11-10 07:00">
                        Înscrierea la întâlnirile de informare si pregătire online începe în:
                    </a>
                </div>
            @else
                <p>
                    Perioada dedicată înscrierii la întâlnirile online de informare și pregătire s-a încheiat.
                </p>
                <div class="pointer-events-none select-none">
                    <script src="https://cdn.logwork.com/widget/countdown.js"></script>
                    <a href="https://logwork.com/countdown-timer" class="countdown-timer"
                        data-style="columns"
                        data-timezone="Europe/Bucharest" data-language="ro" data-date="2024-10-10 07:00">
                        Înscrierea în concursul Lider European, ediția 2024, începe în:
                    </a>
                </div>
            @endif

            <p>
                Gășiți toate informațiile și materialele necesare pe site-ul concursului:

                <a
                    href="https://romania.representation.ec.europa.eu/lider-european_ro"
                    target="_blank"
                    rel="noopener">
                    https://romania.representation.ec.europa.eu/lider-european_ro
                </a>
            </p>

            <p>
                Pentru orice neclarități sau întrebări suplimentare, vă rugăm să ne scrieți pe adresa de e-mail:
                <a href="mailto:concurs@gopa-pace.com">concurs@gopa-pace.com</a>
            </p>

            <p>
                Vă dorim multe idei creative cu care să participați la concurs!
            </p>

            <p>
                O zi frumoasă,<br />
                Echipa Lider European
            </p>
        </div>
    @endif
</div>
