<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">

    <meta name="application-name" content="{{ config('app.name') }}">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>{{ config('app.name') }}</title>

    <style>
        [x-cloak] {
            display: none !important;
        }
    </style>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @livewireStyles
    @livewireScripts
    @stack('scripts')
</head>

<body class="antialiased">
    <header class="relative pt-6 pb-16 sm:pb-24">
        <nav class="relative flex items-center justify-between max-w-3xl px-4 mx-auto md:justify-center sm:px-6">
            <img
                class="w-auto h-10 sm:h-12"
                src="{{ Vite::asset('resources/images/lidereuropean.png') }}"
                alt="">

            <div class="flex items-center justify-end flex-1 space-x-10">
                {{-- <a href="#" class="font-medium text-gray-500 hover:text-gray-900">Product</a> --}}
            </div>
        </nav>
    </header>

    {{ $slot }}

    @livewire('notifications')
</body>

</html>
