<?php

declare(strict_types=1);

namespace App\Notifications;

use App\Models\ContestSignup;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ContestSignupConfirmation extends Notification
{
    use Queueable;

    public function via($notifiable): array
    {
        return ['mail'];
    }

    public function toMail(ContestSignup $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Confirmare înscriere reușită în concursul Lider European 2024')
            ->greeting('Felicitări!')
            ->lines([
                "Vă mulțumim pentru interesul acordat concursului național Lider European, ediția 2024, și vă confirmăm înscrierea echipei **\"$notifiable->nume_echipa\"**!",
                "Codul de identificare al echipei este **{$notifiable->id}**.",
                'Pentru detalii complete privind participarea (calendar, regulament, ghid de pregătire), vă invităm să vizitați pagina noastră dedicată:',
            ])
            ->action('Pagina web dedicată concursului', 'https://romania.representation.ec.europa.eu/lider-european_ro')
            ->lines([
                '## Următorul pas:',
                '**Transmiteți proiectul în perioada 8-11 noiembrie 2024**, conform indicațiilor din regulament, pe adresa de e-mail: [concurs@gopa-pace.com](mailto:concurs@gopa-pace.com)',
                "Asigurați-vă că denumirea documentului include datele de identificare ale echipei, după modelul: **ID {$notifiable->id}_{$notifiable->nume_echipa}_{$notifiable->unitate}**",
                'Pentru orice întrebări sau nelămuriri suplimentare, vă rugăm să ne scrieți la aceeași adresă: [concurs@gopa-pace.com](mailto:concurs@gopa-pace.com).',
                'Vă dorim creativitate și inspirație în competiție!',
            ]);
    }
}
