<?php

declare(strict_types=1);

namespace App\Mail;

use App\Exports\ContestSignupsExport;
use App\Exports\OnlineMeetingSignupsExport;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SignupsExportMail extends Mailable
{
    use Queueable;
    use SerializesModels;

    public string $export;

    public string $filePath;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(string $export, string $filePath)
    {
        $this->export = $export;
        $this->filePath = $filePath;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
            ->subject(match ($this->export) {
                OnlineMeetingSignupsExport::class => 'Export înscrieri întâlniri online',
                ContestSignupsExport::class => 'Export înscrieri concurs',
            })
            ->attachFromStorage($this->filePath)
            ->markdown('mail.signups-export-mail');
    }
}
