<?php

declare(strict_types=1);

namespace App\Http\Livewire;

use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Livewire\Component;

abstract class SignupComponent extends Component implements HasForms
{
    use InteractsWithForms;

    public $data;

    public function mount(): void
    {
        $this->form->fill();
    }

    protected function getFormStatePath(): string
    {
        return 'data';
    }

    protected function registeredSessionKey(): string
    {
        return 'registered-' . self::getName();
    }

    public function registeredDate(): ?string
    {
        return session()->get($this->registeredSessionKey());
    }

    public function hasAlreadyRegistered(): bool
    {
        return $this->registeredDate() !== null;
    }

    public function markAsRegistered(string $data): void
    {
        session()->put($this->registeredSessionKey(), $data);
    }

    public function render()
    {
        return view('livewire.' . self::getName());
    }
}
