<?php

declare(strict_types=1);

namespace App\Exports;

use App\Models\ContestSignup;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Database\Eloquent\Builder;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ContestSignupsExport implements FromQuery, ShouldAutoSize, ShouldQueue, WithHeadings, WithMapping, WithStyles
{
    use Exportable;

    public function query(): Builder
    {
        return ContestSignup::query();
    }

    public function headings(): array
    {
        return [
            '#',
            'Dată înregistrare',

            'Denumire unitate învățământ',
            'Localitate',
            'Județ',
            'Nume și prenume profesor',
            'Număr de telefon',
            'Email',

            'Nume echipă',

            'Nume elev 1',
            'Data nașterii elev 1',
            'Clasa elev 1',

            'Nume elev 2',
            'Data nașterii elev 2',
            'Clasa elev 2',

            'Nume elev 3',
            'Data nașterii elev 3',
            'Clasa elev 3',

            'Nume elev 4',
            'Data nașterii elev 4',
            'Clasa elev 4',
        ];
    }

    /**
     * @param ContestSignup $signup
     */
    public function map($signup): array
    {
        return [
            $signup->id,
            $signup->created_at,

            $signup->unitate,
            $signup->city,
            $signup->county,
            $signup->nume,
            $signup->telefon,
            $signup->email,
            $signup->nume_echipa,

            $signup->echipa[0]['nume'],
            $signup->echipa[0]['data_nasterii'],
            $signup->echipa[0]['clasa'],

            $signup->echipa[1]['nume'],
            $signup->echipa[1]['data_nasterii'],
            $signup->echipa[1]['clasa'],

            $signup->echipa[2]['nume'],
            $signup->echipa[2]['data_nasterii'],
            $signup->echipa[2]['clasa'],

            $signup->echipa[3]['nume'],
            $signup->echipa[3]['data_nasterii'],
            $signup->echipa[3]['clasa'],
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            // Style the first row as bold text.
            1 => ['font' => ['bold' => true]],
        ];
    }
}
