@component('mail::message')
{{-- Greeting --}}
@if (! empty($greeting))
# {{ $greeting }}
@else
# Bună ziua!
@endif

{{-- Intro Lines --}}
@foreach ($introLines as $line)
{{ $line }}

@endforeach

{{-- Action Button --}}
@isset($actionText)
<?php
    $color = match ($level) {
        'success', 'error' => $level,
        default => 'primary',
    };
?>
@component('mail::button', ['url' => $actionUrl, 'color' => $color])
{{ $actionText }}
@endcomponent
@endisset

{{-- Outro Lines --}}
@foreach ($outroLines as $line)
{{ $line }}

@endforeach

{{-- Salutation --}}
@if (! empty($salutation))
{{ $salutation }}
@else
Cu stimă,<br>
Echipa Lider European
@endif

{{-- Subcopy --}}
@isset($actionText)
@slot('subcopy')
**Dacă nu puteți apăsa pe butonul "{{ $actionText }}", copiați adresa de mai jos în browser-ul dvs: <span class="break-all">[{{ $displayableActionUrl }}]({{ $actionUrl }})</span>**
@endslot
@endisset
@endcomponent
