<?php

declare(strict_types=1);

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class ContestSignupFactory extends Factory
{
    public function definition()
    {
        return [
            'unitate' => fake()->name() . ' ' . fake()->city(),
            'nume' => fake()->name(),
            'telefon' => fake()->phoneNumber(),
            'email' => fake()->unique()->safeEmail(),
            'nume_echipa' => fake()->company(),
            'echipa' => collect(range(1, 4))
                ->map(fn () => [
                    'nume' => fake()->name(),
                    'clasa' => fake()->randomElement(['IX', 'X', 'XI', 'XII']),
                    'data_nasterii' => fake()->date(max: now()->subYears(13)),
                ]),
        ];
    }
}
