<?php

declare(strict_types=1);

namespace App\Notifications;

use App\Models\OnlineMeetingSignup;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class OnlineMeetingSignupConfirmation extends Notification
{
    use Queueable;

    public function via($notifiable): array
    {
        return ['mail'];
    }

    public function toMail(OnlineMeetingSignup $notifiable): MailMessage
    {
        $formattedDate = $notifiable->data->isoFormat('D MMMM Y');

        $url = match ($notifiable->data->format('Y-m-d')) {
            '2025-11-18' => 'https://us06web.zoom.us/meeting/register/xxxxxxxxxxxxxxxxxxxx',
        };

        return (new MailMessage)
            ->subject('Confirmare înscriere întâlnire de informare online - Concurs Național Lider European 2025')
            ->lines([
                'Vă mulțumim pentru interesul acordat concursului Lider European, ediția 2025, și vă confirmăm înscrierea la întâlnirea online de informare și pregătire.',
                '## Detalii întâlnire:',
                "**Data:** {$formattedDate}",
                '**Orar:** 10:00 – 12:00 AM (vă rugăm să fiți deja conectați la ora 10:00)',
            ])
            ->action('Link întâlnire', $url)
            ->lines([
                '## Participanți:',
                '- Bogdan Bârla, Information and Communication Officer, Reprezentanța Comisiei Europene în România',
                '- Marinica Stoian, Inspector Ministerul Educației',
                '- Mihai Toader Pasti, Formator [toaderpasti.com](https://www.toaderpasti.com)',
                '## Recomandări:',
                'Asigurați-vă că aveți un calculator/laptop cu o conexiune stabilă la internet, microfon închis și cameră web activă pe parcursul întâlnirii. Vă încurajăm să veniți cu întrebări pentru discuții pe tema Uniunii Europene, programe pentru elevi sau validarea ideilor de proiecte.',
                'Pentru orice întrebări, ne puteți contacta la: concurs@gopa-pace.com',
                'Vă dorim succes și inspirație în pregătirea pentru concurs!',
            ]);
    }
}
