<?php

declare(strict_types=1);

namespace App\Models;

use App\Notifications\ContestSignupConfirmation;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;

class ContestSignup extends Model
{
    use HasFactory;
    use Notifiable;

    protected $guarded = [
        'rules', 'gdpr',
    ];

    protected $casts = [
        'echipa' => 'json',
    ];

    public function sendNotification()
    {
        return $this->notify(new ContestSignupConfirmation());
    }
}
