<?php

declare(strict_types=1);

namespace App\Jobs;

use App\Mail\SignupsExportMail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class SendExport implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public string $export;

    public string $email;

    public string $filePath;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(string $export, string $email, string $filePath)
    {
        $this->export = $export;
        $this->email = $email;
        $this->filePath = $filePath;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        Mail::to($this->email)->send(
            new SignupsExportMail($this->export, $this->filePath)
        );
    }
}
